<?php
/*
PHP version 5
Copyright (c) 2002-2010 ECISP.CN
声明：这不是一个免费的软件，请在许可范围内使用
http://www.ecisp.cn	http://www.easysitepm.com
*/
class POP3 {
	/**
	 * Default POP3 port
	 * @var int
	 */
	var $POP3_PORT = 110;

	/**
	 * Default Timeout
	 * @var int
	 */
	var $POP3_TIMEOUT = 30;

	/**
	 * POP3 Carriage Return + Line Feed
	 * @var string
	 */
	var $CRLF = "\r\n";

	/**
	 * Displaying Debug warnings? (0 = now, 1+ = yes)
	 * @var int
	 */
	var $do_debug = 2;

	/**
	 * POP3 Mail Server
	 * @var string
	 */
	var $host;

	/**
	 * POP3 Port
	 * @var int
	 */
	var $port;

	/**
	 * POP3 Timeout Value
	 * @var int
	 */
	var $tval;

	/**
	 * POP3 Username
	 * @var string
	 */
	var $username;

	/**
	 * POP3 Password
	 * @var string
	 */
	var $password;

	/**#@+
	* @access private
	 */
	var $pop_conn;
	var $connected;
	var $error;
	/**#@-*/

	/**
	 * Constructor, sets the initial values
	 *
	 * @return POP3
	 */
	function POP3 () {
		$this->pop_conn = 0;
		$this->connected = false;
		$this->error = null;
	}

	/**
	 * Combination of public events - connect, login, disconnect
	 *
	 * @param string $host
	 * @param integer $port
	 * @param integer $tval
	 * @param string $username
	 * @param string $password
	 */
	function Authorise ($host, $port = false, $tval = false, $username, $password, $debug_level = 0) {
		$this->host = $host;
		if ($port == false) {
			$this->port = $this->POP3_PORT;
		}
		else {
			$this->port = $port;
		}
		if ($tval == false) {
			$this->tval = $this->POP3_TIMEOUT;
		}
		else {
			$this->tval = $tval;
		}

		$this->do_debug = $debug_level;
		$this->username = $username;
		$this->password = $password;
		$this->error = null;
		$result = $this->Connect($this->host, $this->port, $this->tval);

		if ($result) {
			$login_result = $this->Login($this->username, $this->password);

			if ($login_result) {
				$this->Disconnect();

				return true;
			}

		}
		$this->Disconnect();

		return false;
	}

	/**
	 * Connect to the POP3 server
	 *
	 * @param string $host
	 * @param integer $port
	 * @param integer $tval
	 * @return boolean
	 */
	function Connect ($host, $port = false, $tval = 30) {
		if ($this->connected) {
			return true;
		}

		/*
		On Windows this will raise a PHP Warning error if the hostname doesn't exist.
		Rather than supress it with @fsockopen, let's capture it cleanly instead
		*/

		set_error_handler(array(&$this, 'catchWarning'));
		$this->pop_conn = fsockopen($host,
			$port,
			$errno,
			$errstr,
			$tval);
		restore_error_handler();
		if ($this->error && $this->do_debug >= 1) {
			$this->displayErrors();
		}
		if ($this->pop_conn == false) {
			$this->error = array(
				'error' => "Failed to connect to server $host on port $port",
				'errno' => $errno,
				'errstr' => $errstr
			);

			if ($this->do_debug >= 1) {
				$this->displayErrors();
			}

			return false;
		}
		if (version_compare(phpversion(), '4.3.0', 'ge')) {
			stream_set_timeout($this->pop_conn, $tval, 0);
		}
		else {
			if (substr(PHP_OS, 0, 3) !== 'WIN') {
				socket_set_timeout($this->pop_conn, $tval, 0);
			}
		}
		$pop3_response = $this->getResponse();
		if ($this->checkResponse($pop3_response)) {
			$this->connected = true;
			return true;
		}

	}

	/**
	 * Login to the POP3 server (does not support APOP yet)
	 *
	 * @param string $username
	 * @param string $password
	 * @return boolean
	 */
	function Login ($username = '', $password = '') {
		if ($this->connected == false) {
			$this->error = 'Not connected to POP3 server';

			if ($this->do_debug >= 1) {
				$this->displayErrors();
			}
		}

		if (empty($username)) {
			$username = $this->username;
		}

		if (empty($password)) {
			$password = $this->password;
		}

		$pop_username = "USER $username" . $this->CRLF;
		$pop_password = "PASS $password" . $this->CRLF;
		$this->sendString($pop_username);
		$pop3_response = $this->getResponse();

		if ($this->checkResponse($pop3_response)) {
			$this->sendString($pop_password);
			$pop3_response = $this->getResponse();

			if ($this->checkResponse($pop3_response)) {
				return true;
			}
			else {
				return false;
			}
		}
		else {
			return false;
		}
	}

	/**
	 * Disconnect from the POP3 server
	 */
	function Disconnect () {
		$this->sendString('QUIT');

		fclose($this->pop_conn);
	}

	/*
	---------------
	Private Methods
	---------------
	*/

	/**
	 * Get the socket response back.
	 * $size is the maximum number of bytes to retrieve
	 *
	 * @param integer $size
	 * @return string
	 */
	function getResponse ($size = 128) {
		$pop3_response = fgets($this->pop_conn, $size);

		return $pop3_response;
	}

	/**
	 * Send a string down the open socket connection to the POP3 server
	 *
	 * @param string $string
	 * @return integer
	 */
	function sendString ($string) {
		$bytes_sent = fwrite($this->pop_conn, $string, strlen($string));

		return $bytes_sent;

	}

	/**
	 * Checks the POP3 server response for +OK or -ERR
	 *
	 * @param string $string
	 * @return boolean
	 */
	function checkResponse ($string) {
		if (substr($string, 0, 3) !== '+OK') {
			$this->error = array(
				'error' => "Server reported an error: $string",
				'errno' => 0,
				'errstr' => ''
			);

			if ($this->do_debug >= 1) {
				$this->displayErrors();
			}

			return false;
		}
		else {
			return true;
		}

	}

	/**
	 * If debug is enabled, display the error message array
	 *
	 */
	function displayErrors () {
		echo '<pre>';

		foreach ($this->error as $single_error) {
			print_r($single_error);
		}

		echo '</pre>';
	}

	/**
	 * Takes over from PHP for the socket warning handler
	 *
	 * @param integer $errno
	 * @param string $errstr
	 * @param string $errfile
	 * @param integer $errline
	 */
	function catchWarning ($errno, $errstr, $errfile, $errline) {
		$this->error[] = array(
			'error' => "Connecting to the POP3 server raised a PHP warning: ",
			'errno' => $errno,
			'errstr' => $errstr
		);
	}
}
?>
